(load "dbmc.lisp")

(defun main ()

  (let ((ap nil)
        (up nil)
        (rp nil)
        (sp nil)
        (input-file nil))

    (labels

        ((usage-message ()
           (let ((options (list "-cnf filename"
                                "-p (full | mem | cnf | none)"
                                "-r" "+r" "-s" "+s" "-u" "+u")))
             (format *error-output*
                     "correct usage: ~A [~{~a~^ | ~}]* file~%"
                     (car *posix-argv*)
                     options)
             (sb-ext:quit :unix-status 1)))

         (solve-bat-problem (file)
           (with-open-file (stream file :direction :input)
             (let ((format (read stream)))
               (case format
                 (:forall
                  (let ((vars (read stream))
                        (functs (read stream))
                        (form (read stream)))
                    (solve-formula-forall
                     file vars functs form
                     (if *nicesat-file* :none :minisat)
                     :ap ap :up up :rp rp :sp sp)))
                 (:exists
                  (let ((vars (read stream))
                        (functs (read stream))
                        (form (read stream)))
                    (solve-formula-exists
                     file vars functs form
                     (if *nicesat-file* :none :minisat)
                     :ap ap :up up :rp rp :sp sp)))
                 (:machine
                  (let ((desc (read stream))
                        (steps (read stream)))
                    (dbmc
                     file desc steps
                     (if *nicesat-file* :none :minisat)
                     :ap ap :up up :rp rp :sp sp)))))))

         (set-parameter (arg)
           (let ((return-value t))
             (cond
               ((equal arg "-u")
                (setf up nil))
               ((equal arg "+u")
                (setf up t))
               ((equal arg "-r")
                (setf rp nil))
               ((equal arg "+r")
                (setf rp t))
               ((equal arg "+s")
                (setf sp t))
               ((equal arg "-s")
                (setf sp nil))
               (t (setf return-value nil)))
             return-value))

         (parse-arguments (args)
           (if (consp args)
               (let ((arg (first args)))
                 (cond ((equal arg "-cnf")
                        (setf *nicesat-file* (second args))
                        (parse-arguments (cddr args)))
                       ((equal arg "-p")
                        (let ((arg2 (second args)))
                          (cond ((equal arg2 "full") (setf ap t))
                                ((equal arg2 "mem") (setf ap 'mem))
                                ((equal arg2 "cnf") (setf ap 'cnf))
                                ((equal arg2 "none") (setf ap nil))
                                (t (format
                                    *error-output*
                                    "unknown propagation option: ~A~%"
                                    arg2)
                                   (sb-ext:quit :unix-status 1)))
                          (parse-arguments (cddr args))))
                       ((set-parameter arg)
                        (parse-arguments (cdr args)))
                       (input-file (usage-message))
                       (t (setf input-file arg)
                          (format t "input file: ~A~%" input-file)
                          (parse-arguments (cdr args))))))))

      (if (< (length *posix-argv*) 2)
          (usage-message)
          (parse-arguments (cdr *posix-argv*)))

      (if input-file
          (solve-bat-problem input-file)
          (usage-message)))))

#+sbcl (save-lisp-and-die
        "nice-bat"
        :toplevel #'main
        :executable t)
